﻿/*!
\file rdbapi.js
\author tomsoft jiangyong
*/
var _wsurl = null; //连接URL, 比如 WSS://kipway.net
var _wsusr = null;   //用户名
var _wspsw = null;   //密码
var _wsobject = null;  // WS连接对象
var _loginst = false;  //当前登录状态

var g_seqno = 0; // 全局连续递增的序列号，仅供nextseqno使用，不要直接使用。

/**
 * 获取下一个seqno号,1到MAXINT32之间
 * @return {number} 返回整数
 * */
function nextseqno() {
	g_seqno++;
	if (g_seqno === 2147483647)
		g_seqno = 1;
	return g_seqno;
}

/**
 * 异步登录实时库,创建WS连接,保存登录参数,在rdbws_onopen里发送登录请求.
 * @param {string} wsurl 实时库连接地址,WSS://kipway.net
 * @param {string} usr  用户名
 * @param {string} psw  用户密码
 * @return {boolean} 返回连接成功
 */
function ws_connect(wsurl, usr, psw) {
	_loginst = false;
	try {
		_wsurl = wsurl;
		_wsusr = usr;
		_wspsw = psw;

		_wsobject = new WebSocket(_wsurl, "rdb5");
		_wsobject.onopen = ws_onopen;
		_wsobject.onmessage = ws_onmessage;
		_wsobject.onclose = ws_onclose;
		return true;
	}
	catch (e) {
		console.log("Login do Err:", e);
		return false;
	}
}

function ws_islogin() {
	return _loginst;
}

/*!
\brief 登出
断开连接，清空会话存储的URL,USR,PSW,SUBP参数
*/
function ws_disconnet() {
	try {
		sessionStorage.removeItem("_sswsurl");
		sessionStorage.removeItem("_sswsusr");
		sessionStorage.removeItem("_sswspswd");
		if (_wsobject) {
			_wsobject.close();
			_wsobject = null;
		}
		_loginst = false;
	}
	catch (e) {
		console.log("ws_disconnet Err:", e);
	}
}

/**
 * WS连接回调处理,发送登录消息。
 * @param {object} event ws事件
 */
function ws_onopen(event) {
	var oreq = {};
	oreq.request = "rdb_login";
	oreq.seqno = nextseqno();
	oreq.name = _wsusr;
	oreq.timefmt = "iso";
	ws_send(JSON.stringify(oreq));
}


/**
 * 处理WS接受消息
 * @param {object} event ws事件
 */
function ws_onmessage(event) {
	if (typeof OnWsMessage === "function") {
		OnWsMessage(event);//应用层可以实现这个函数获得原始消息
	}
	try {
		var cls = JSON.parse(event.data);
		if (cls.response === "rdb_login") {
			if (cls.status !== 0) {
				console.log("onlogin Err:", cls);
				if (typeof onlogin_st === "function") {
					onlogin_st(false);
					_wsobject.close();
					_wsobject = null;
				}
				return;
			}
			var oreq = {};
			oreq.request = "rdb_auth";
			oreq.seqno = nextseqno();
			oreq.vals = hex_md5(cls.vals + hex_md5(_wspsw).toUpperCase()).toUpperCase();
			ws_send(JSON.stringify(oreq));
		} else if (cls.response === "rdb_auth") {
			if (cls.status !== 0) {
				console.log("onauth Err:", cls);
				if (typeof onlogin_st === "function") {
					onlogin_st(false);
					_wsobject.close();
					_wsobject = null;
				}
			} else {
				console.log("login success!", cls);
				sessionStorage.setItem("_sswsurl", _wsurl);
				sessionStorage.setItem("_sswsusr", _wsusr);
				sessionStorage.setItem("_sswspswd", _wspsw);
				if (typeof onlogin_st === "function")
					onlogin_st(true);
				if (typeof svg_onlogin === "function")
					svg_onlogin(); //登录成功通知SVG
				_loginst = true;
			}
		}
		else {
			if (typeof OnSvgReadData === "function") {
				if (OnSvgReadData(cls)) //SVG的数据
					return;
			}
			if (typeof OnMsgReadData === "function")
				OnMsgReadData(cls); //其他数据
		}
	}
	catch (e) {
		console.log("ws_onmessage do Err:", e);
	}
}

/**
 * WS连接段凯事件处理,可以在这里面做断线重连.
 * @param {object} event WS事件
 */
function ws_onclose(event) {
	console.log("ws_onclose", event);
	_loginst = false;
	if (typeof on_wsclosed === "function")
		on_wsclosed(event);
}

/**
 * 发送JSON字符串到实时库。
 * @param {string} str  需要发送给实时库的字符串
 * @return {boolean} true:success;  false:failed;
 */
function ws_send(str) {	
	try {
		if (_wsobject === null || _wsobject.readyState !== _wsobject.OPEN)
			return false;
		_wsobject.send(str);
	} catch (e) {
		return false;
	}
	return true;
}

/**
 * 自动连接,连接参数存储在sessionStorage里面。
 * @return {Boolean} 返回创建连接成功
 * */
function ws_autologin() {
	if (!_wsobject) {
		try {
			var wsurl = sessionStorage.getItem("_sswsurl");
			var usr = sessionStorage.getItem("_sswsusr");
			var psw = sessionStorage.getItem("_sswspswd");
			if (!wsurl || !usr || !psw)
				return false;
			return ws_connect(wsurl, usr, psw);
		} catch (e) {
			console.log("ws_connect Err:", e);
			return false;
		}
	}
}

/**
 \fn	function rdb_tagstation(tagname)

 \brief	获取标签名的子站名

 \param 	tagname	标签名.

 \returns	{string} 如果没有子站名返回null
 */

function rdb_tagstation(tagname) {
	var i;
	for (i = 0; i < tagname.length; i++) {
		if (tagname.charAt(i) === ':') {
			return tagname.slice(0, i);
		}
		else if (tagname.charAt(i) === '.')
			break;
	}
	return null;
}

/**
 * 标签分类转换为字符串
 * @param {number} nclass 标签分类
 * @return {string} 返回字符串
 */
function rdb_class2str(nclass) {
	var str = "unkown";
	switch (nclass) {
		case 0: str = "DEC"; break;
		case 1: str = "DEFINE"; break;
		case 2: str = "PRESET"; break;
		case 3: str = "CURVE"; break;
		case 4: str = "SYSTEM"; break;
	}
	return str;
}

/**
 * 标签类型转换为字符串
 * @param {number} ndt 标签类型
 * @return {string} 返回至字符串
 */
function rdb_dt2str(ndt) {
	var str = "void";
	switch (ndt) {
		case 1: str = "digital"; break;
		case 2: str = "int32"; break;
		case 3: str = "float32"; break;
		case 4: str = "int64"; break;
		case 5: str = "float64"; break;
		case 6: str = "string"; break;
		case 7: str = "object"; break;
	}
	return str;
}

/**
 * 标签类型字符串转换为数字
 * @param {string} sdt 类型字符串
 * @return {number} 返回数字类型
 */
function rdb_str2dt(sdt) {
	var sl = sdt.toLowerCase();
	var v = 0;
	switch (sl) {
		case "digital":
			v = 1; break;
		case "int":
		case "int32":
			v = 2; break;

		case "float":
		case "float32":
			v = 3; break;

		case "int64":
		case "long":
			v = 4; break;

		case "float64":
		case "double":
			v = 5; break;

		case "string":
		case "str":
			v = 6; break;
		case "object":
		case "obj":
		case "blob":
			v = 7; break;
	}
	return v;
}

/**
 * 标签压缩方式转换字符串
 * @param {number} n 压缩方式
 * @return {string} 返回字符串
 */
function rdb_comp2str(n) {
	var str = "no";
	switch (n) {
		case 1: str = "percent"; break;
		case 2: str = "abs"; break;
		case 3: str = "timer"; break;
		case 4: str = "extimer"; break;
	}
	return str;
}

/**
 * 标签压缩方式字符串转换为数字
 * @param {string} s 压缩方式字符串
 * @return {number} 返回数字
 */
function rdb_str2comp(s) {
	var sl = s.toLowerCase();
	var v = 0;
	switch (sl) {
		case "no":
		case "none":
			v = 0; break;

		case "per":
		case "percent":
			v = 1; break;

		case "value":
		case "abs":
			v = 2; break;

		case "timer":
		case "time":
			v = 3; break;

		case "extimer":
		case "extime":
			v = 4; break;
	}
	return v;
}

/**
 * 检测是不是IE浏览器
 * */
function jt_isie() {
	var Sys = {};
	var ua = navigator.userAgent.toLowerCase();
	var s;
	(s = ua.match(/rv:([\d.]+)\) like gecko/)) ? Sys.ie = s[1] :
		(s = ua.match(/msie ([\d.]+)/)) ? Sys.ie = s[1] :
			(s = ua.match(/firefox\/([\d.]+)/)) ? Sys.firefox = s[1] :
				(s = ua.match(/chrome\/([\d.]+)/)) ? Sys.chrome = s[1] :
					(s = ua.match(/opera.([\d.]+)/)) ? Sys.opera = s[1] :
						(s = ua.match(/version\/([\d.]+).*safari/)) ? Sys.safari = s[1] : 0;
	if (Sys.ie) alert("此页面不支持IE浏览器,请使用chrome或firefox");
}


