#!/bin/bash

INST_UPDATE=1
DEST_BIN_DIR="/usr/local/bin/ipv6ds/"
SERVICE_NAME="ipv6ds.service"
SERVICE_FILE="/etc/systemd/system/${SERVICE_NAME}"

if [[ ! -f ${SERVICE_FILE} ]]; then
	echo "install as new"
	INST_UPDATE=0
    mkdir -p ${DEST_BIN_DIR}
    cp -v ${SERVICE_NAME} ${SERVICE_FILE}
    systemctl enable ${SERVICE_NAME}
    systemctl daemon-reload
fi

BIN_NAME="ipv6ds"
SRC_BIN_FILE="${BIN_NAME}"
DEST_BIN_FILE="${DEST_BIN_DIR}${BIN_NAME}"

#if running, stop it
if [[ "XX`pidof ${BIN_NAME}`" != "XX" ]]; then
	INST_UPDATE=1
	echo "install as update"
	echo "${BIN_NAME} is running, stop it."
	systemctl stop ${SERVICE_NAME}
    echo "${SERVICE_NAME} stopped."
	sleep 2
fi

#copy bin file
cp -v ${SRC_BIN_FILE} ${DEST_BIN_DIR}
chmod +x ${DEST_BIN_FILE}

#copy other files
if [[ ${INST_UPDATE} == 0 ]]; then
	cp -v ipv6ds.ini ${DEST_BIN_DIR}
	cp -v librdbapix64.so ${DEST_BIN_DIR}
	echo -e "install success."	
else	
	echo -e "update success."
fi

#install success
echo "please Please configure ${DEST_BIN_DIR}ipv6ds.ini and then use systemctl to start the ${SERVICE_NAME}."

#start service
#echo "start ${BIN_NAME}"
#systemctl start ${BIN_NAME}
#${DEST_BIN_DIR}${BIN_NAME} -status





