﻿/*!
\file wsapi.js
	封装logsrv等使用的两次握手无密码交换登录过程的websocket客户端，封装登录过程。
\author jiangyong
\update 
	2025-4-18 使用ES6 class 重新包装，无全局变量
*/

class LogSrvClient {
	constructor() {
		this._wsurl = null;
		this._wsusr = null;   //用户名
		this._wspsw = null;   //密码
		this._wsprotocol = "json"; // Sec-WebSocket-Protocol 值，应用层定义,默认"json"
		this._wsobject = null;  // WS连接对象
		this._loginst = false;  //当前登录状态

		this._seqno = 0; // 全局连续递增的序列号，仅供nextseqno使用，不要直接使用。
		this._version = "";
		this._build = "";

		this._ssid_wsurl = "_logss_wsurl";
		this._ssid_wsuser = "_logss_wsuser";
		this._ssid_wspswd = "_logss_wspswd";

		this._OnRecvMessage = (event) => { }; //接收到的原始消息(event)
		this._OnLoginStatus = (bool) => { }; //登录状态改变 (bool)
		this._OnRecvObject = (jsoncls) => { }; //处理已解析的json对象 (jsoncls)
		this._OnWsClosed = (event) => { }; // 已关闭 (event)
	}

	/**
	 * 递增序列号
	 * @returns 返回1-2147483646序列号
	 */
	nextseqno() {
		this._seqno++;
		if (this._seqno === 2147483647)
			this._seqno = 1;
		return this._seqno;
	}

	/**
	 * 创建websocket连接，并安装消息处理函数
	 * @param {string} wsurl 连接地址 ws://192.168.1.59:999
	 * @param {string} usr 登录用户名
	 * @param {string} psw 登录密码
	 * @returns 返回bool值 true or false
	 */
	ws_connect(wsurl, usr, psw) {
		this._loginst = false;
		this._wsurl = wsurl;
		this._wsusr = usr;
		this._wspsw = psw;
		try {
			this._wsobject = new WebSocket(this._wsurl, this._wsprotocol);
		} catch (e) {
			console.log("new WebSocket Err:", e);
			return false;
		}
		//安装连接成功处理
		this._wsobject.onopen = (event) => {
			let oreq = {};
			oreq.request = "ws_login";
			oreq.seqno = this.nextseqno();
			oreq.name = this._wsusr;
			this.ws_send(JSON.stringify(oreq));
		};
		//安装接收WS消息处理
		this._wsobject.onmessage = (event) => {
			this._OnRecvMessage(event);
			let cls = null;
			try {
				cls = JSON.parse(event.data);
			}
			catch (e) {
				console.log("onmessage JSON.parse Err:", e);
				return;
			}
			if (cls.response === "ws_login") {
				if (cls.status !== 0) { //登录失败关闭连接
					console.log("onlogin Err:", cls);
					this._OnLoginStatus(false);
					this._wsobject.close();
					this._wsobject = null;
					return;
				}
				let oreq = {};
				oreq.request = "ws_auth";
				oreq.seqno = this.nextseqno();
				oreq.vals = hex_md5(cls.vals + hex_md5(this._wspsw).toUpperCase()).toUpperCase();
				this.ws_send(JSON.stringify(oreq));
			} else if (cls.response === "ws_auth") {
				if (cls.status !== 0) { //验证失败关闭连接
					console.log("onauth Err:", cls);
					this._OnLoginStatus(false);
					this._wsobject.close();
					this._wsobject = null;
				} else {
					console.log("login success!", cls);
					sessionStorage.setItem(this._ssid_wsurl, this._wsurl);
					sessionStorage.setItem(this._ssid_wsuser, this._wsusr);
					sessionStorage.setItem(this._ssid_wspswd, this._wspsw);
					if (cls.version != undefined) {
						this._version = cls.version;
					}
					if (cls.build != undefined) {
						this._build = cls.build;
					}
					this._OnLoginStatus(true);
					this._loginst = true;
				}
			}
			else {
				this._OnRecvObject(cls); //其他数据
			}
		};
		//安装关闭处理
		this._wsobject.onclose = (event) => {
			console.log("ws_onclose", event);
			this._loginst = false;
			this._OnWsClosed(event);
		};
		return true;
	}

	/**
	* 获取当前登录状态
	* @returns 返回bool值 true or false
	*/
	ws_islogin() {
		return this._loginst;
	}

	/**
	 * 自动登录，从sessionStorage去除登录参数登录，用于页面切换后重新登录
	 * @returns true or false
	 */
	ws_autologin() //自动登录
	{
		if (!this._wsobject) {
			try {
				let wsurl = sessionStorage.getItem(this._ssid_wsurl);
				let usr = sessionStorage.getItem(this._ssid_wsuser);
				let psw = sessionStorage.getItem(this._ssid_wspswd);
				if (!wsurl || !usr || !psw)
					return false;
				return this.ws_connect(wsurl, usr, psw);
			} catch (e) {
				console.log("ws_connect Err:", e);
				return false;
			}
		}
		return true;
	}

	/**
	 * 主动断开
	 * @returns 无
	 */
	ws_disconnet()//主动断开
	{
		try {
			sessionStorage.removeItem(this._ssid_wsurl);
			sessionStorage.removeItem(this._ssid_wsuser);
			sessionStorage.removeItem(this._ssid_wspswd);
			if (this._wsobject) {
				this._wsobject.close();
				this._wsobject = null;
			}
			this._loginst = false;
		}
		catch (e) {
			console.log("ws_disconnet Err:", e);
		}
	}

	/**
	 * 发送消息
	 * @param {string} str 发送的JSON字符串
	 * @returns true or false
	 */
	ws_send(str)//发送消息
	{
		try {
			if (this._wsobject === null || this._wsobject.readyState !== this._wsobject.OPEN)
				return false;
			this._wsobject.send(str);
		} catch (e) {
			return false;
		}
		return true;
	}
}

/**
 * 检测是不是IE浏览器，并使用alert弹窗
 * @returns 无
 */
function jt_isie() {
	var Sys = {};
	var ua = navigator.userAgent.toLowerCase();
	var s;
	(s = ua.match(/rv:([\d.]+)\) like gecko/)) ? Sys.ie = s[1] :
		(s = ua.match(/msie ([\d.]+)/)) ? Sys.ie = s[1] :
			(s = ua.match(/firefox\/([\d.]+)/)) ? Sys.firefox = s[1] :
				(s = ua.match(/chrome\/([\d.]+)/)) ? Sys.chrome = s[1] :
					(s = ua.match(/opera.([\d.]+)/)) ? Sys.opera = s[1] :
						(s = ua.match(/version\/([\d.]+).*safari/)) ? Sys.safari = s[1] : 0;
	if (Sys.ie) alert("此页面不支持IE浏览器,请使用chrome或firefox");
}


