﻿/*!
\file wsapi.js
\author jiangyong
*/

var info_page_footer = "重庆唐码软件有限公司  © 2009-2022  <a href=\"http://www.kipway.com\">www.kipway.com</a> 版权所有 <br> QQ:459222361 微信: kipway";

var _wsurl = null; //连接URL, 比如 wss://kipway.net
var _wsusr = null;   //用户名
var _wspsw = null;   //密码
var _wsobject = null;  // WS连接对象
var _loginst = false;  //当前登录状态

var g_seqno = 0; // 全局连续递增的序列号，仅供nextseqno使用，不要直接使用。
var g_version = "";
var g_build = "";

var ssid_wsurl = "_logss_wsurl";
var ssid_wsuser = "_logss_wsuser";
var ssid_wspswd = "_logss_wspswd";

/**
 * 获取下一个seqno号,1到MAXINT32之间
 * @return {number} 返回整数
 * */
function nextseqno() {
	g_seqno++;
	if (g_seqno === 2147483647)
		g_seqno = 1;
	return g_seqno;
}

/**
 * 异步登录,创建WS连接,保存登录参数,在rdbws_onopen里发送登录请求.
 * @param {string} wsurl 实时库连接地址,WSS://kipway.net
 * @param {string} usr  用户名
 * @param {string} psw  用户密码
 * @return {boolean} 返回连接成功
 */
function ws_connect(wsurl, usr, psw) {
	_loginst = false;
	try {
		_wsurl = wsurl;
		_wsusr = usr;
		_wspsw = psw;

		_wsobject = new WebSocket(_wsurl, "json");
		_wsobject.onopen = ws_onopen;
		_wsobject.onmessage = ws_onmessage;
		_wsobject.onclose = ws_onclose;
		return true;
	}
	catch (e) {
		console.log("Login do Err:", e);
		return false;
	}
}

function ws_islogin() {
	return _loginst;
}

/*!
\brief 登出
断开连接，清空会话存储的URL,USR,PSW,SUBP参数
*/
function ws_disconnet() {
	try {
		sessionStorage.removeItem(ssid_wsurl);
		sessionStorage.removeItem(ssid_wsuser);
		sessionStorage.removeItem(ssid_wspswd);
		if (_wsobject) {
			_wsobject.close();
			_wsobject = null;
		}
		_loginst = false;
	}
	catch (e) {
		console.log("ws_disconnet Err:", e);
	}
}

/**
 * WS连接回调处理,发送登录消息。
 * @param {object} event ws事件
 */
function ws_onopen(event) {
	var oreq = {};
	oreq.request = "ws_login";
	oreq.seqno = nextseqno();
	oreq.name = _wsusr;
	ws_send(JSON.stringify(oreq));
}


/**
 * 处理WS接受消息
 * @param {object} event ws事件
 */
function ws_onmessage(event) {
	if (typeof OnWsMessage === "function") {
		OnWsMessage(event);//应用层可以实现这个函数获得原始消息
	}
	try {
		var cls = JSON.parse(event.data);
		if (cls.response === "ws_login") {
			if (cls.status !== 0) {
				console.log("onlogin Err:", cls);
				if (typeof onlogin_st === "function") {
					onlogin_st(false);
					_wsobject.close();
					_wsobject = null;
				}
				return;
			}
			var oreq = {};
			oreq.request = "ws_auth";
			oreq.seqno = nextseqno();
			oreq.vals = hex_md5(cls.vals + hex_md5(_wspsw).toUpperCase()).toUpperCase();
			ws_send(JSON.stringify(oreq));
		} else if (cls.response === "ws_auth") {
			if (cls.status !== 0) {
				console.log("onauth Err:", cls);
				if (typeof onlogin_st === "function") {
					onlogin_st(false);
					_wsobject.close();
					_wsobject = null;
				}
			} else {
				console.log("login success!", cls);
				sessionStorage.setItem(ssid_wsurl, _wsurl);
				sessionStorage.setItem(ssid_wsuser, _wsusr);
				sessionStorage.setItem(ssid_wspswd, _wspsw);
				if (cls.version != undefined) {
					g_version = cls.version;
				}
				if (cls.build != undefined) {
					g_build = cls.build;
				}
				if (typeof onlogin_st === "function")
					onlogin_st(true);
				if (typeof svg_onlogin === "function")
					svg_onlogin(); //登录成功通知SVG
				_loginst = true;
			}
		}
		else {
			if (typeof OnSvgReadData === "function") {
				if (OnSvgReadData(cls)) //SVG的数据
					return;
			}
			if (typeof OnMsgReadData === "function")
				OnMsgReadData(cls); //其他数据
		}
	}
	catch (e) {
		console.log("ws_onmessage do Err:", e);
	}
}

/**
 * WS连接段凯事件处理,可以在这里面做断线重连.
 * @param {object} event WS事件
 */
function ws_onclose(event) {
	console.log("ws_onclose", event);
	_loginst = false;
	if (typeof on_wsclosed === "function")
		on_wsclosed(event);
}

/**
 * 发送JSON字符串。
 * @param {string} str  需要发送给实时库的字符串
 * @return {boolean} true:success;  false:failed;
 */
function ws_send(str) {		
	try {
		if (_wsobject === null || _wsobject.readyState !== _wsobject.OPEN)
			return false;
		_wsobject.send(str);
	} catch (e) {
		return false;
	}
	return true;
}

/**
 * 自动连接,连接参数存储在sessionStorage里面。
 * @return {Boolean} 返回创建连接成功
 * */
function ws_autologin() {
	if (!_wsobject) {
		try {
			var wsurl = sessionStorage.getItem(ssid_wsurl);
			var usr = sessionStorage.getItem(ssid_wsuser);
			var psw = sessionStorage.getItem(ssid_wspswd);
			if (!wsurl || !usr || !psw)
				return false;
			return ws_connect(wsurl, usr, psw);
		} catch (e) {
			console.log("ws_connect Err:", e);
			return false;
		}
	}
}


/**
 * 检测是不是IE浏览器
 * */
function jt_isie() {
	var Sys = {};
	var ua = navigator.userAgent.toLowerCase();
	var s;
	(s = ua.match(/rv:([\d.]+)\) like gecko/)) ? Sys.ie = s[1] :
		(s = ua.match(/msie ([\d.]+)/)) ? Sys.ie = s[1] :
			(s = ua.match(/firefox\/([\d.]+)/)) ? Sys.firefox = s[1] :
				(s = ua.match(/chrome\/([\d.]+)/)) ? Sys.chrome = s[1] :
					(s = ua.match(/opera.([\d.]+)/)) ? Sys.opera = s[1] :
						(s = ua.match(/version\/([\d.]+).*safari/)) ? Sys.safari = s[1] : 0;
	if (Sys.ie) alert("此页面不支持IE浏览器,请使用chrome或firefox");
}


