﻿using System;

namespace csapitst
{
    /// <summary>
    /// 这个类写的很粗糙，只是简单说明api接口的用法。
    /// </summary>
    internal class dbtst
    {
        private System.Collections.ArrayList _objs = new System.Collections.ArrayList();//对象数组，用于存放回调函数读取的标签或历史记录

        public dbtst()
        {
        }

        /// <summary>
        /// 读取值标签的快照
        /// </summary>
        public void tst_valgetsnap(int dbh)
        {
            int i, n = 4;
            string[] tags = { "d0.i01.pv", "d0.f01.pv", "d0.dbl01.pv", "d0.l01.pv" };
            rdb.rec_tagval[] v = new rdb.rec_tagval[n];
            for (i = 0; i < n; i++)
                v[i].sname = tags[i];

            int nret = rdb.dbi.rdb_valgetsnapshot(dbh, v, n);
            if (nret != rdb.def.SE_OK)
            {
                if (nret == rdb.def.SE_NOTCONNECT)
                    Console.Write("没有连接实时库，请先使用connect命令连接实时库\n");
                else
                    Console.Write("rdb_valgetsnapshot error {0}\n", nret);
                return;
            }
            Int32 year = 0, mon = 0, day = 0, hour = 0, min = 0, sec = 0, msec = 0;
            for (i = 0; i < n; i++)
            {
                if (v[i].val.cerr != 0)
                {
                    Console.Write(v[i].sname + "Err = {0:D}\n", v[i].val.cerr);
                    continue;
                }
                rdb.dbi.rdb_rdbtime2localtime(v[i].val.time, ref year, ref mon, ref day, ref hour, ref min, ref sec, ref msec);
                Console.Write(v[i].sname + " time = {0:D4}-{1:D2}-{2:D2} {3:D2}:{4:D2}:{5:D2}.{6:D3} qa = {7:D} val = ",
                    year, mon, day, hour, min, sec, msec, v[i].val.cqa);
                if (v[i].val.cvt == rdb.def.DT_FLOAT32)
                    Console.Write("{0:F}\n", v[i].val.v.f32);
                else if (v[i].val.cvt == rdb.def.DT_FLOAT64)
                    Console.Write("{0:G}\n", v[i].val.v.f64);
                else if (v[i].val.cvt == rdb.def.DT_INT32)
                    Console.Write("{0:D}\n", v[i].val.v.i32);
                else if (v[i].val.cvt == rdb.def.DT_INT64)
                    Console.Write("{0:D}\n", v[i].val.v.i64);
                else
                    Console.Write("未知数据类型\n");
            }
        }

        /// <summary>
        /// 读取对象标签快照
        /// </summary>
        public void tst_objgetsnap(int dbh)
        {
            int i, n = 2;
            string[] tags = { "d0.str01.pv", "d0.obj01.pv" };
            rdb.rec_tagobj[] v = new rdb.rec_tagobj[n];
            for (i = 0; i < n; i++)
                v[i].sname = tags[i];

            int nret = rdb.dbi.rdb_objgetsnapshot(dbh, v, n);
            if (nret != rdb.def.SE_OK)
            {
                if (nret == rdb.def.SE_NOTCONNECT)
                    Console.Write("没有连接实时库，请先使用connect命令连接实时库\n");
                else
                    Console.Write("rdb_objgetsnapshot error {0}\n", nret);
                return;
            }
            Int32 year = 0, mon = 0, day = 0, hour = 0, min = 0, sec = 0, msec = 0;
            for (i = 0; i < n; i++)
            {
                if (v[i].var.cerr != 0)
                {
                    Console.Write(v[i].sname + "Err = {0:D}\n", v[i].var.cerr);
                    continue;
                }
                rdb.dbi.rdb_rdbtime2localtime(v[i].var.time, ref year, ref mon, ref day, ref hour, ref min, ref sec, ref msec);
                Console.Write(v[i].sname + " time = {0:D4}-{1:D2}-{2:D2} {3:D2}:{4:D2}:{5:D2}.{6:D3} qa = {7:D} val = ",
                    year, mon, day, hour, min, sec, msec, v[i].var.cqa);
                if (v[i].var.cvt == rdb.def.DT_STRING)
                    Console.Write("string:{0}\n", v[i].var.sdata);
                else if (v[i].var.cvt == rdb.def.DT_OBJECT)
                    Console.Write("object:len={0:D}\n", v[i].var.uslen);
                else
                    Console.Write("未知数据类型\n");
            }
        }

        /// <summary>
        /// 标签查询回调函数
        /// </summary>
        /// <param name="ptags"> 标签数组</param>
        /// <param name="ntags"> 标签数</param>
        /// <param name="lparam">回调参数</param>
        /// <returns> true 继续，false停止查询</returns>
        public bool OnTag([System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.LPArray,SizeParamIndex = 1),
            System.Runtime.InteropServices.In] rdb.rec_tag[] ptags,
            int ntags, System.IntPtr lparam)
        {
            int i;
            for (i = 0; i < ntags; i++)
            {
                _objs.Add(ptags[i]);
                if (_objs.Count >= 10000)
                    return false; //只读取前面10000个
            }
            return true;
        }

        /// <summary>
        /// 标签查询测试，查询最多1万条记录，并打印前面10条记录
        /// </summary>
        public void tst_tagquery(int dbh) //读取最多10000个标签
        {
            _objs.Clear();///清空
            int nret = rdb.dbi.rdb_tagquery(dbh, "", "", -1, -1, OnTag, (IntPtr)null);///读取全部标签
            if (nret != rdb.def.SE_OK)
            {
                if (nret == rdb.def.SE_NOTCONNECT)
                    Console.Write("没有连接实时库，请先使用connect命令连接实时库\n");
                else
                    Console.Write("rdb_tagquery errcode = {0}\n", nret);
                return;
            }
            System.Console.Write("rdb_tagquery tags = top {0}\n The table below shows top 10 lines\n", _objs.Count);///输出读取个数
            //显示10个

            int n = 0;
            foreach (rdb.rec_tag obj in _objs)
            {
                Console.Write("   {0}\n", obj.sname);
                n++;
                if (n > 10)
                    break;
            }
            Console.Write("success\n");
        }

        /// <summary>
        /// 标签值记录回掉函数
        /// </summary>
        /// <param name="pvals"></param>
        /// <param name="nitems"></param>
        /// <param name="pParam"></param>
        /// <returns></returns>
        public bool OnReadVals([System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.LPArray, SizeParamIndex = 1),
        System.Runtime.InteropServices.In]  rdb.rec_val[] pvals,
        int nitems, System.IntPtr pParam)
        {
            int i;
            for (i = 0; i < nitems; i++)
            {
                _objs.Add(pvals[i]);
                if (_objs.Count >= 10000)
                    return false; //只读取前面10000个
            }
            return true;
        }

        /// <summary>
        /// 查询标签的历史样本值记录,最多读取10000条记录
        /// </summary>
        public void tst_valquery(int dbh)
        {
            int year = 0, mon = 0, day = 0, hour = 0, min = 0, sec = 0, msec = 0;
            long lts = rdb.dbi.rdb_localtime2rdbtime(2020, 12, 1, 0, 0, 0, 0);
            long lte = -1;
            long lds = 0;//样本值

            _objs.Clear();///清空
            int nret = rdb.dbi.rdb_valquery(dbh, "d0.f01.pv", "", lts, lte, lds, 0, OnReadVals, (IntPtr)null);
            if (nret != rdb.def.SE_OK)
            {
                if (nret == rdb.def.SE_NOTCONNECT)
                    Console.Write("没有连接实时库，请先使用connect命令连接实时库\n");
                else
                    Console.Write("rdb_valquery errcode = {0}\n", nret);
                return;
            }
            System.Console.Write("rdb_valquery recs = top {0}\n The table below shows top 10 lines\n", _objs.Count);///输出读取个数

            //显示10个
            int n = 0;
            foreach (rdb.rec_val obj in _objs)
            {
                if (obj.cerr != 0)
                    continue;
                rdb.dbi.rdb_rdbtime2localtime(obj.time, ref year, ref mon, ref day, ref hour, ref min, ref sec, ref msec);
                Console.Write("time = {0:D4}-{1:D2}-{2:D2} {3:D2}:{4:D2}:{5:D2}.{6:D3} qa = {7:D} val = ", year, mon, day, hour, min, sec, msec, obj.cqa);
                if (obj.cvt == rdb.def.DT_FLOAT32)
                    Console.Write("{0:F}\n", obj.v.f32);
                else if (obj.cvt == rdb.def.DT_FLOAT64)
                    Console.Write("{0:G}\n", obj.v.f64);
                else if (obj.cvt == rdb.def.DT_INT32)
                    Console.Write("{0:D}\n", obj.v.i32);
                else if (obj.cvt == rdb.def.DT_INT64)
                    Console.Write("{0:D}\n", obj.v.i64);
                else
                    Console.Write("未知数据类型\n");
                n++;
                if (n > 10)
                    break;
            }
            Console.Write("success\n");
        }

        public bool OnReadObjs(
            [System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.LPArray, SizeParamIndex = 1),
            System.Runtime.InteropServices.In]  rdb.rec_obj[] pobjs,
            int nitems, System.IntPtr pParam)
        {
            int i;
            for (i = 0; i < nitems; i++)
            {
                _objs.Add(pobjs[i]);
                if (_objs.Count >= 10000)
                    return false; //只读取前面10000个
            }
            return true;
        }

        public void tst_objget(int dbh)
        {
            int year = 0, mon = 0, day = 0, hour = 0, min = 0, sec = 0, msec = 0;
            long lts = rdb.dbi.rdb_localtime2rdbtime(2020, 12, 1, 0, 0, 0, 0);
            long lte = -1;

            _objs.Clear();///清空
            int nret = rdb.dbi.rdb_objget(dbh, "d0.str01.pv", lts, lte, OnReadObjs, (IntPtr)null);
            if (nret != rdb.def.SE_OK)
            {
                if (nret == rdb.def.SE_NOTCONNECT)
                    Console.Write("没有连接实时库，请先使用connect命令连接实时库\n");
                else
                    Console.Write("rdb_objget errcode = {0}\n", nret);
                return;
            }
            System.Console.Write("rdb_objget recs = top {0}\n The table below shows top 10 lines\n", _objs.Count);///输出读取个数

            //显示10个
            int n = 0;
            foreach (rdb.rec_obj obj in _objs)
            {
                rdb.dbi.rdb_rdbtime2localtime(obj.time, ref year, ref mon, ref day, ref hour, ref min, ref sec, ref msec);
                Console.Write("time = {0:D4}-{1:D2}-{2:D2} {3:D2}:{4:D2}:{5:D2}.{6:D3} qa = {7:D} val = ", year, mon, day, hour, min, sec, msec, obj.cqa);

                if (obj.cvt == rdb.def.DT_STRING)
                    Console.Write("string:{0}\n", obj.sdata);
                else if (obj.cvt == rdb.def.DT_OBJECT)
                    Console.Write("object:len={0:D}\n", obj.uslen);
                else
                    Console.Write("未知数据类型\n");
                n++;
                if (n > 10)
                    break;
            }
            Console.Write("success\n");
        }

        /// <summary>
        /// SOE查询回调函数
        /// </summary>
        /// <param name="psoes"></param>
        /// <param name="nitems"></param>
        /// <param name="pParam"></param>
        /// <returns></returns>
        public bool OnReadSoes(
            [System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.LPArray, SizeParamIndex = 1),
            System.Runtime.InteropServices.In]  rdb.rec_soe[] psoes,
            int nitems, System.IntPtr pParam)
        {
            int i;
            for (i = 0; i < nitems; i++)
            {
                _objs.Add(psoes[i]);
                if (_objs.Count >= 10000)
                    return false; //只读取前面10000个
            }
            return true;
        }

        /// <summary>
        /// SOE查询
        /// </summary>
        public void tst_soequery(int dbh)
        {
            int year = 0, mon = 0, day = 0, hour = 0, min = 0, sec = 0, msec = 0;
            long lts = rdb.dbi.rdb_localtime2rdbtime(2016, 5, 1, 0, 0, 0, 0);
            long lte = -1;

            _objs.Clear();///清空
            int nret = rdb.dbi.rdb_soequery(dbh, lts, 0, lte, "", OnReadSoes, (IntPtr)null);
            if (nret != rdb.def.SE_OK)
            {
                if (nret == rdb.def.SE_NOTCONNECT)
                    Console.Write("没有连接实时库，请先使用connect命令连接实时库\n");
                else
                    Console.Write("rdb_soequery errcode = {0}\n", nret);
                return;
            }
            System.Console.Write("rdb_soequery recs = top {0}\n The table below shows top 10 lines\n", _objs.Count);///输出读取个数

            //显示10个
            int n = 0;
            foreach (rdb.rec_soe obj in _objs)
            {
                rdb.dbi.rdb_rdbtime2localtime(obj.time, ref year, ref mon, ref day, ref hour, ref min, ref sec, ref msec);
                Console.Write("time = {0:D4}-{1:D2}-{2:D2} {3:D2}:{4:D2}:{5:D2}.{6:D3} ", year, mon, day, hour, min, sec, msec);
                Console.Write("source={0};des={1};type={2:D}\n", obj.source, obj.sdes, obj.type);
                n++;
                if (n > 10)
                    break;
            }
            Console.Write("success\n");
        }

        /// <summary>
        /// 写值标签的快照
        /// </summary>
        public void tst_valputsnap(int dbh)
        {
            int i, n = 4;
            string[] tags = { "tst000.dbl0000", "tst000.flt0001", "tst000.int0002", "tst000.long0003" };
            rdb.rec_tagval[] v = new rdb.rec_tagval[n];
            for (i = 0; i < n; i++) //填写名称，时标，数据质量
            {
                v[i].sname = tags[i];
                v[i].val.time = rdb.dbi.rdb_time();
                v[i].val.v.u64 = 0; //清空数据
                v[i].val.cqa = 0;
                v[i].val.cerr = 0;
                v[i].val.cres = 0;
            }

            //下面填写值和数据类型
            v[0].val.cvt = rdb.def.DT_FLOAT64;
            v[0].val.v.f64 = 100.123456;

            v[1].val.cvt = rdb.def.DT_FLOAT32;
            v[1].val.v.f32 = (float)10.123;

            v[2].val.cvt = rdb.def.DT_INT32;
            v[2].val.v.i32 = 30;

            v[3].val.cvt = rdb.def.DT_INT64;
            v[3].val.v.i64 = 300;

            int nret = rdb.dbi.rdb_valputsnapshot(dbh, v, n);
            if (nret != rdb.def.SE_OK)
            {
                if (nret == rdb.def.SE_NOTCONNECT)
                    Console.Write("没有连接实时库，请先使用connect命令连接实时库\n");
                else
                    Console.Write("rdb_valputsnapshot error {0}\n", nret);
                return;
            }

            for (i = 0; i < n; i++)
            {
                if (v[i].val.cerr != 0)
                    Console.Write(v[i].sname + " Err = {0:D}\n", v[i].val.cerr);
                else
                    Console.Write(v[i].sname + " success\n");
            }
        }

        /// <summary>
        /// 写字符串对象标签的快照
        /// </summary>
        public void tst_objputsnap(int dbh)
        {
            int i, n = 1;
            string[] tags = { "中文标签" };
            rdb.rec_tagobj[] v = new rdb.rec_tagobj[n];
            for (i = 0; i < n; i++) //填写名称，时标，数据质量
            {
                v[i].sname = tags[i];
                v[i].var.time = rdb.dbi.rdb_time();
                v[i].var.uobjtype = 0;
                v[i].var.cqa = 0;
                v[i].var.cerr = 0;
                v[i].var.cres = 0;
                v[i].var.sdata = "中文内容";
                v[i].var.uslen = (ushort)System.Text.Encoding.Default.GetBytes(v[i].var.sdata.ToCharArray()).Length;
                v[i].var.cvt = rdb.def.DT_STRING;
            }
            int nret = rdb.dbi.rdb_objputsnapshot(dbh, v, n);
            if (nret != rdb.def.SE_OK)
            {
                if (nret == rdb.def.SE_NOTCONNECT)
                    Console.Write("没有连接实时库，请先使用connect命令连接实时库\n");
                else
                    Console.Write("rdb_objputsnapshot error {0}\n", nret);
                return;
            }

            for (i = 0; i < n; i++)
            {
                if (v[i].var.cerr != 0)
                    Console.Write(v[i].sname + " Err = {0:D}\n", v[i].var.cerr);
                else
                    Console.Write(v[i].sname + " success\n");
            }
        }
    };

    internal class tstmain
    {
        private static void help()
        {
            Console.WriteLine("command:");

            Console.WriteLine("connect [url user pass]   连接到实时库,无参数表示连接到阿里云demo库");
            Console.WriteLine("help                        帮助");
            Console.WriteLine("valgetsnap                  读值标签快照");
            Console.WriteLine("objgetsnap                  读对象标签快照");
            Console.WriteLine("tagquery                    查询标签");
            Console.WriteLine("valquery                    查询标签历史样本值记录");
            Console.WriteLine("objget                      读取对象标签历史记录");
            Console.WriteLine("soequery                    SOE查询");
            Console.WriteLine("valputsnap                  写值标签快照");
            Console.WriteLine("exit                        退出");
        }

        private static void Main(string[] args)
        {
            int nret = 0;

            int dbh = rdb.dbi.rdb_create();///创建接口句柄,这个接口句柄可以一直重复使用，直到程序退出,
            //记住不用了要调用rdb.dbi.rdb_destory(dbh) 释放句柄回收资源。
            
            if (dbh == rdb.def.SE_ERRHANDLE)
            {
                Console.WriteLine("rdb_create error!");
                return; //创建句柄失败
            }

            dbtst db = new dbtst();
            help();

            char[] sp = { ' ', ',', '\t', '\n' };
            string so;
            string[] a;

            while (true)
            {
                so = Console.ReadLine();
                if (so == "exit")
                    break;
                a = so.Split(sp, StringSplitOptions.RemoveEmptyEntries);
                if (so.Length < 1)
                    continue;

                if (string.Compare(a[0], "connect", true) == 0)///连接实时库
                {
                    if (a.Length == 4)
                        nret = rdb.dbi.rdb_connectex(dbh, a[1], a[2], a[3], 15); // 15秒超时
                    else if (a.Length == 1)//不带参数连接阿里云demo库
                        nret = rdb.dbi.rdb_connectex(dbh, "wss://kipway.net", "opt1", "opt1", 15); // 15秒超时
                    else
                    {
                        Console.WriteLine("错误的参数, 例子:  connect wss://kipway.net opt1 opt1 ");
                        continue;
                    }

                    if (nret != rdb.def.DBR_SUCCESS)
                        Console.Write("rdb_connect error {0:D}\n", nret);
                    else
                        Console.WriteLine("rdb_connect success");
                }
                else if (0 == string.Compare(a[0], "valgetsnap", true))///读值标签取快照
                    db.tst_valgetsnap(dbh);
                else if (0 == string.Compare(a[0], "objgetsnap", true))///读取对象标签快照
                    db.tst_objgetsnap(dbh);
                else if (0 == string.Compare(a[0], "tagquery", true))///查询标签
                    db.tst_tagquery(dbh);
                else if (0 == string.Compare(a[0], "valquery", true))///查询历史纪录
                    db.tst_valquery(dbh);
                else if (0 == string.Compare(a[0], "objget", true))///查询历史纪录
                    db.tst_objget(dbh);
                else if (0 == string.Compare(a[0], "soequery", true))///查询历史纪录
                    db.tst_soequery(dbh);
                else if (0 == string.Compare(a[0], "valputsnap", true))///写值标签快照
                    db.tst_valputsnap(dbh);
                else if (0 == string.Compare(a[0], "objputsnap", true))///写字符串标签快照
                    db.tst_objputsnap(dbh);
                else
                {
                    Console.WriteLine("error command!\n");
                    help();
                }
            }
            //这里记住一定要销毁句柄 dbh 释放资源
            rdb.dbi.rdb_disconnect(dbh);///断开连接
            rdb.dbi.rdb_destory(dbh);///销毁接口句柄
            dbh = rdb.def.SE_ERRHANDLE;
        } // Main
    }
}