/*
 * 这里展示了如何使用jniwsapi的静态方法链接实时库，发送请求命令，获取结果并使用JsonParse解析返回的JSON消息的过程。
 * 其中WS/WSS通讯使用的是C++实现的JNI接口，JSON对象的解析使用的是纯java实现的JsonParse类，实际应用请使用java自带
 * 的json解析。
 */
package kipway;

import java.util.Scanner;
import java.util.ArrayList;

class TagVal { // 测试用的标签值
	public TagVal() {
		_qa = 0;
		_dtype = 6; // 默认字符串类型DT_STRING
	}

	public String _name; // 标签名
	public String _time; // 时标
	public int _qa; // 质量
	public int _dtype; // 数据类型
	public String _val; // 标签值
}

public class tstwsapi {
	public static final int PRT_TABSIZE = 2; /// 打印解析后的JSON对象用的缩进制表符宽度

	private static void PrtHelp() {
		System.out.println("\nType the following command to start the test\n");
		System.out.println("  rdb_getruninfo");
		System.out.println("  rdb_listsession");
		System.out.println("  rdb_getsnap");
		System.out.println("  help");
		System.out.println("  exit");
	}

	public static void main(String[] args) {
		// 实时库连接地址(作者的阿里云演示库使用wss的默认443端口所有url不带端口)，不带的TLS1.2的协议为ws，例如 "ws://192.168.1.19:921"
		String url = "wss://kipway.net";
		// 日志服务器的url地址,如果不使用客户端日志，可以为设置为""或者null
		String logurl = "udp://127.0.0.1:999/tstwsapi"; // logsrv的日志服务url
		int handle = jniwsapi.Create(url, "opt1", "opt1", logurl); // 建立一个连接
		if (handle < 0) {
			System.out.println("Create failed!");
			return;
		}
		// 先读取一下状态,看是否登录成功了。Create后Jni会自动维护连接,断线自动重连。连接好后，就可以调用各种接口了。
		if (jniwsapi.ST_SUCCESS == jniwsapi.getStatus(handle))
			System.out.println("\nCreate success, handle = " + handle + ", connect to " + url + " success!");
		else
			System.out.println("\nCreate success! handle = " + handle + ", " + url + "  connecting...");// 正在连接。
		PrtHelp();
		Scanner sc = new Scanner(System.in);
		tstwsapi tst = new tstwsapi();
		System.out.print("\n>>");
		while (true) { // 在控制台输入命令测试提供,具体请求消息格式参见《rdb_data_exchange_protocol.pdf》
			String cmdstr = sc.next();
			if (0 == cmdstr.compareToIgnoreCase("exit"))
				break;
			else if (0 == cmdstr.compareToIgnoreCase("rdb_getruninfo")) {
				tst.rdb_getruninfo(handle);
			} else if (0 == cmdstr.compareToIgnoreCase("rdb_listsession")) {
				tst.rdb_getsession(handle);
			} else if (0 == cmdstr.compareToIgnoreCase("rdb_getsnap")) {
				tst.rdb_getsnap(handle);
			} else if (0 == cmdstr.compareToIgnoreCase("help")) {
				PrtHelp();
			} else
				System.out.println("unkown request!");
			System.out.print("\n>>");
		}
		sc.close();
		jniwsapi.Close(handle);
		// 一定要调用这个Close释放JNI的资源和线程，和Java IO流一样需要手动释放系统资源，否则会耗尽一个进程最大64个实时库连接资源。
		System.out.println("exit success.");
		return;
	}

	/*
	 * @ 测试读取实时库运行信息.
	 */
	private void rdb_getruninfo(int handle) {
		String sreq = String.format("{\"request\":\"rdb_getruninfo\",\"seqno\":%d}", jniwsapi.getNextSeqno(handle));
		try {
			byte[] rs = jniwsapi.Call(handle, sreq.getBytes("UTF-8"));
			System.out.print(new String(rs, "UTF-8")); // 打印收到的原始JSON消息

			// 下面解析并格式化输出所有JSON节点
			System.out.println("\n\n-------------------JsonParse-------------------");
			JsonParse js = new JsonParse(rs);
			if (!js.Parse()) {
				System.out.println("Parse JSON failed.");
				return;
			}
			JsonParse.printJson(js, 0, PRT_TABSIZE);// 打印整个JSON对象
		} catch (Exception e) {
			System.out.println(e.toString());
		}
	}

	/*
	 * @ 测试读取实时库当前会话连接列表
	 */
	private void rdb_getsession(int handle) {
		String sreq = "{\"request\":\"rdb_listsession\"}"; // 可以不需要seqno, JNI会自动添加seqno字段
		try {
			byte[] rs = jniwsapi.Call(handle, sreq.getBytes("UTF-8"));
			System.out.print(new String(rs, "UTF-8")); // 打印收到的原始JSON消息
			// 下面解析并格式化输出所有JSON节点
			System.out.println("\n\n-------------------JsonParse-------------------");
			JsonParse js = JsonParse.Parse(rs);
			JsonParse.printJson(js, 0, PRT_TABSIZE);// 打印整个JSON对象

		} catch (Exception e) {
			System.out.println(e.toString());
		}
	}

	/*
	 * @ 测试读取快照。
	 */
	private void rdb_getsnap(int handle) {
		String[] tags = { "d0.f01.pv", "d0.i01.pv", "d0.str01.pv" }; // 假设标签表在一个数组里。
		StringBuilder req = new StringBuilder(); // 构建请求消息
		req.append("{\"request\":\"rdb_getsnap\",\"seqno\":").append(jniwsapi.getNextSeqno(handle))
				.append(",\"tags\":[");
		for (int i = 0; i < tags.length; i++) {
			if (i > 0)
				req.append(',');
			req.append('"').append(tags[i]).append('"');
		}
		req.append("]}");
		try {
			byte[] rs = jniwsapi.Call(handle, req.toString().getBytes("UTF-8"));
			System.out.print(new String(rs, "UTF-8")); // 打印收到的原始JSON消息

			// 下面解析并格式化输出所有JSON节点
			System.out.println("\n\n-------------------JsonParse-------------------");
			JsonParse js = JsonParse.Parse(rs);
			JsonParse.printJson(js, 0, PRT_TABSIZE);// 打印整个JSON对象

			// 下面测试按照标签名读取值的字符串
			System.out.println("\n\n------Test JsonParse other functions------");
			String sval = js.getNodeVal("seqno");
			System.out.println("js.getNodeVal(\"seqno\") = " + sval);
			sval = js.getNodeVal("status");
			System.out.println("js.getNodeVal(\"status\") = " + sval);
			sval = js.getNodeVal("response");
			System.out.println("js.getNodeVal(\"response\") = " + sval);

			NodeType vtp = js.getNodeType(0);
			System.out.println("js.getNodeType(0) = " + vtp);
			vtp = js.getNodeType("responSe");
			System.out.println("js.getNodeType(\"responSe\") = " + vtp);
			vtp = js.getNodeType("Seqno");
			System.out.println("js.getNodeType(\"Seqno\") = " + vtp);

			// 测试将快照解析为记录集
			System.out.println("\n------Parse value to ArrayList<TagVal>------");
			ArrayList<TagVal> recs = parsesnap(rs);
			for (TagVal v : recs) {
				System.out
						.println("Name=" + v._name + "; Time=" + v._time + "; Quality=" + v._qa + "; Value=" + v._val);
			}
		} catch (Exception e) {
			System.out.println(e.toString());
		}
	}

	/*
	 * 将读快照解析到标签值数组
	 * 
	 * @param resp JsonParse.Call返回的响应消息。
	 */
	private static ArrayList<TagVal> parsesnap(byte[] resp) throws Exception {
		JsonParse js = new JsonParse(resp);
		if (!js.Parse()) {
			throw new Exception("Parse failed.");
		}
		String sv = js.getNodeVal("status"); // 检查错误码
		if (!sv.isEmpty()) { // status 默认值0，对于默认值，服务端可以不编码该字段。
			if (0 != Integer.parseInt(sv))
				return new ArrayList<TagVal>(); // 有错返回一个空的集合。
		}
		try {
			JsonParse jvs = js.ParseNode("vals");
			ArrayList<TagVal> vr = new ArrayList<TagVal>(jvs.getNodeSize());
			for (int i = 0; i < jvs.getNodeSize(); i++) {
				JsonParse jv = jvs.ParseNode(i);
				if (Integer.parseInt(jv.getNodeVal("E")) != 0)
					continue; // 有错误码的去除
				TagVal v = new TagVal();
				v._name = jv.getNodeVal("N");
				v._time = jv.getNodeVal("T");
				v._qa = 0; // 默认值,有可能服务端不编码这个字段
				try {
					v._qa = Integer.parseInt(jv.getNodeVal("Q"));
				} catch (Exception e) {
				}
				v._val = jv.getNodeVal("V");
				vr.add(v);
			}
			return vr;
		} catch (Exception e) {
			throw e;
		}
	}
}
