/*!
\file test_count.js 
2025.4(inner version 5123)版新增的统计API例子
*/

global g_ct = 0; //全局变量

global g_jobname = "test_count"; //在日中中显示的任务名，只是为了区分日志内容

function logflag() //日志标志，用于在日志中却分是哪个脚本产生的日志
{
	return "[" + g_jobname + "] ";
}

function init()
{	
	logout("dbg",logflag() + "init script \n  g_ct = " + g_ct.to_string());
}

function log_tagval(msginfo , v) //使用dbg级别输出一个标签值到日志，用于调试
{
	logout("dbg", msginfo + 
		"\n  time: " + rdbtime_to_isostr(v.ti) + 
	"\n  QA  : " + v.qa.to_string() + 
	"\n  iv  : " + v.iv.to_string() + 
	"\n  uv  : " + v.uv.to_string() + 
	"\n  fv  : " + v.fv.to_string() + 
	
	"\n  lv  : " + v.lv.to_string() + 
	"\n  ulv : " + v.ulv.to_string() + 
	"\n  dblv: " + v.dblv.to_string() 
	);
}

function run()
{
	g_ct += 1;
	logout("dbg",logflag() + "g_ct = " + g_ct.to_string());

	//测试读取增量
	var vinc = rdb_countincrement("d0.f01.pv", "2025-03-01T01:0:0.000+08:00", "2025-03-01T02:0:0.000+08:00");	
	log_tagval(logflag() + "rdb_countincrement", vinc);

	//统计积分累计
	var vintegral = rdb_countintegral("d0.f01.pv", "2025-03-01T01:0:0.000+08:00", "2025-03-01T02:0:0.000+08:00", 60);
	log_tagval(logflag() + "rdb_countintegral", vintegral);	
}

init(); //初始化只会执行一次