/*!
\file test_cycle.js
周期执行综合测试例子脚本
*/

global g_ct; //测试全局变量,这里用于计数被调用了多少次。
global g_jobname = "test_cycle";

function logflag() //日志标志，用于在日志中却分是哪个脚本产生的日志
{
	return "[" + g_jobname + "] ";
}

function init()
{	
	g_ct = 0; //初始为0
	logout("dbg",logflag() + "init script, g_ct = " + g_ct.to_string());
}

function log_tagval(msginfo , v) //使用dbg级别输出一个标签值到日志，用于调试
{
	logout("dbg", msginfo + 
	"\n  time: " + rdbtime_to_str(v.ti) + 
	"\n  QA  : " + v.qa.to_string() + 
	"\n  iv  : " + v.iv.to_string() + 
	"\n  uv  : " + v.uv.to_string() + 
	"\n  fv  : " + v.fv.to_string() + 
	
	"\n  lv  : " + v.lv.to_string() + 
	"\n  ulv : " + v.ulv.to_string() + 
	"\n  dblv: " + v.dblv.to_string() 
	);
}

function test_writedevice() //测试写入值到设备
{
	var stag = "m1.f4tof4rw";
	var vr = rdb_getsnapval(stag); //先读取标签值,然后每次增长0.5写回设备去
	log_tagval(logflag() + stag,vr); // 输出到日志看是否正确
	var v = vr.dblv;
	if(vr.qa == 0){		
		v += 0.5; //每次增长0.5
	}
	else{
		v = 1.0; //如果没有初值，设置初始化值为1.0
	}
	var nret = rdb_writedevice(stag, v); //写入
	if(nret != 0){
		logout("err",logflag() + "write device " + stag + " val= " + v.to_string() + " failed, error code = " + nret.to_string());	
	}
	else{
		logout("msg",logflag() + "write device " + stag + " val= " + v.to_string() + " success");	
	}
}

function test_writesnap() //测试写入快照到实时库
{
	var stag = "tst.int01";	
	var vr = rdb_getsnapval(stag); //先读取标签值,然后每次加1再写回快照
	log_tagval(logflag() + stag, vr); // 输出到日志看是否正确
	var v = vr.iv;
	if(vr.qa == 0){		
		v += 1; //每次增长1
	}
	else{
		v = 1; //如果没有初值，设置初始化值为1
	}
	var nret = rdb_writesnap(stag, 0ll , 0 , v); //写入
	if(nret != 0){
		logout("err",logflag() + "writesnap " + stag + " val= " + v.to_string() + " failed, error code = " + nret.to_string());	
	}
	else{
		logout("msg",logflag() + "writesnap " + stag + " val= " + v.to_string() + " success");	
	}
}

function test_rdbtime() //测试实时库格式时间
{
	var ltime = rdb_time();
	logout("dbg",logflag() + "rdb_time() = " + ltime.to_string());
	var strtime = rdbtime_to_str(ltime);
	logout("dbg",logflag() + "rdbtime_to_str(" + ltime.to_string() + ") = " + strtime);
	var ltimenew = str_to_rdbtime(strtime);
	logout("dbg",logflag() + "str_to_rdbtime(" + "\"" + strtime + "\"" + ") = " + ltime.to_string());
}

function run() // 主运行函数,按照配置定时或者周期性被执行，注意不要有间接或者直接死循环在里面。
{
	g_ct += 1;
	logout("dbg",logflag() + "g_ct = " + g_ct.to_string()); // 测试全局变量,调用次数输出到日志

	test_writedevice(); //测试写入到设备
	test_writesnap(); //测试写入快照	
	
	test_rdbtime(); //测试实时库时标解析
}

init(); //初始化只会执行一次