/*!
\file test_file.js
测试文件读写

*/

global g_jobname = "test_file";

global  SEEK_CUR = 1;
global  SEEK_END = 2;
global  SEEK_SET = 0;

function logflag() //日志标志，用于在日志中却分是哪个脚本产生的日志
{
	return "[" + g_jobname + "] ";
}

function test_write() //测试创建文件并写入文件
{
	var fl = cFile();
	var filename = "./tst1.txt";
	if (!fl.open(filename, "w+")) {
		logout("dbg", logflag() + "open failed!");
		return;
	}
	if (0 == fl.write("this is write string!")) {
		logout("dbg", logflag() + "write failed!");
		return;
	}
	fl.close();
}

function test_read() //测试读一块内容
{
	var fl = cFile();
	var filename = "./tst1.txt";
	if (!fl.open(filename, "r")) {
		logout("dbg", logflag() + "open failed!");
		return;
	}
	var txt = fl.read(4096);
	logout("dbg", logflag() + "read:" + txt.to_string());
	fl.close();
}

function test_read2() //把文件所有内容读到string中
{
	var fl = cFile();
	var filename = "./tst1.txt";
	if (!fl.open(filename, "r")) {
		logout("dbg", logflag() + "open failed!");
		return;
	}
	var txt = "";
	var c = fl.getc();
	while (c != -1) {
		txt.push_back(c);
		c = fl.getc();
	}
	logout("dbg", logflag() + "read:" + txt);
	fl.close();
}

function test_rewrite() //测试seek，改写内容
{
	var fl = cFile();
	var filename = "./tst1.txt";
	if (!fl.open(filename, "r+")) {
		logout("dbg", logflag() + "open failed!");
		return;
	}
	if (fl.seek(4, SEEK_SET) < 0) { //移动到开始到4的位置
		logout("dbg", logflag() + "seek failed");
		return;
	}
	if (0 == fl.write(" rewrite ")) {
		logout("dbg", logflag() + "write failed!");
		return;
	}
	if (fl.seek(0, SEEK_SET) < 0) { //移动到开始
		logout("dbg", logflag() + "seek failed");
		return;
	}
	var txt = "";
	var c = fl.getc();
	while (c != -1) {
		txt.push_back(c);
		c = fl.getc();
	}
	logout("dbg", logflag() + "read:" + txt);
	fl.close();
}

function test_filsesize() //测试 teel和 seek
{
	var fl = cFile();
	var filename = "./tst1.txt";
	if (!fl.open(filename, "r")) {
		logout("dbg", logflag() + "open failed!");
		return;
	}
	if (fl.seek(0, SEEK_END) < 0) { //移动到文件尾
		logout("dbg", logflag() + "seek to end failed");
		return;
	}
	var lsize = fl.tell();
	if (lsize < 0) {
		logout("dbg", logflag() + "tell failed!");
		return;
	}
	logout("dbg", logflag() + "file size: " + lsize.to_string());
	fl.close();
}

function run() {
	test_write();
	test_read();
	test_read2();
	test_rewrite();
	test_filsesize();
}




