/*!
\file test_str.js
测试字符串t_str对象
*/

global g_jobname = "test_str";

function logflag() //日志标志，用于在日志中却分是哪个脚本产生的日志
{
	return "[" + g_jobname + "] ";
}

function teststr() //测试字符串对象
{		
	var v = t_str();
	v.setstr("set string");
	logout("dbg", logflag() + 
	"\n  time: " + rdbtime_to_str(v.ti) + 
	"\n  QA  : " + v.qa.to_string() + 
	"\n  str : " + v.getstr()
	);
}

function getsnapstr(string stag) //读取字符串标签快照
{		
	var v = rdb_getsnapstr(stag);
	logout("dbg", logflag() + 
	"\n  time: " + rdbtime_to_str(v.ti) + 
	"\n  QA  : " + v.qa.to_string() + 
	"\n  str : " + v.getstr()
	);
}

function writesnap(string stag,string vstr)
{	
	var nret = rdb_writesnapstr(stag,0,0,vstr);//默认使用当前时间和0质量	
	if(nret != 0){
		logout("err",logflag() + "rdb_writesnapstr(" + stag + ") error " + nret.to_string());
	}
	else{
		logout("dbg",logflag() + "rdb_writesnapstr(" + stag + ") success.");
	}
}

function writedevice(string stag,string vstr)
{
	var nret = rdb_writedevicestr(stag,vstr);	
	if(nret != 0){
		logout("err",logflag() + "rdb_writedevicestr(" + stag + ") error " + nret.to_string());
	}
	else{
		logout("dbg",logflag() + "rdb_writedevicestr(" + stag + ") success.");
	}
}

function run()
{
	teststr();
	getsnapstr("d0.str00.pv");
	writesnap("d0.str00.pv","test write snap!");
	writedevice("d0.str00.pv","test write device!");
}

 


