﻿// simudrv.cpp
// 注意，本程序需要支持C11标准的编译器。VS2015,VS2017, GCC 4.8.3及以上

#include "simudrv.h"

#include "rdbdrv/rdbdef.h"
#include "rdbdrv/dacdrv.h"

#define DRVTAG_R                1 //!<只读
#define DRVTAG_W                2 //!<只写
#define DRVTAG_RW               3 //!<读写

/*!
@brief 包装的驱动类,直接从一个线程继承而来
*/
class cSimuSrv : public cThread
{
public:
	cSimuSrv() : _sdevice{ 0 }, _cfgfile{ 0 } {
		_onmsg = 0;     //消息日志回调函数
		_onmsgparam = 0;

		_ontagval = 0; //值标签数据记录回调函数
		_ontagvalparam = 0;

		_ontagobj = 0; //对象标签数据记录回调函数
		_ontagobjparam = 0;

		_onsoe = 0;    //SOE回掉函数
		_onsoeparam = 0;

		_tlast = 0;
	}
	virtual ~cSimuSrv() {};
private:
	struct t_tagitem //标签定义 
	{
		char tagname[80]; //实时库标签名
		int  type;        //实时数据库的数据类型,DT_INT32等
		int  access;      //访问方式 DRVTAG_R等  DRVTAG_RW
		char unit[16];	  //工程单位
		char des[80];	  //描述
	};
public:
	bool Create(const char* sdevicename, const char* scfgfile,
		dac_onmsg onmsg, void* onmsgparam,
		dac_ontagval ontagval, void* ontagvalparam,
		dac_ontagobj ontagobj, void *ontagobjparam,
		dac_onsoe onsoe, void* onsoeparam)
	{
		if (!sdevicename || !(*sdevicename) || !scfgfile || !(*scfgfile) || !ontagval)
			return false;
		strncpy(_sdevice, sdevicename, sizeof(_sdevice) - 1);

		if (!load_cfg(scfgfile)) //读入并解析驱动设备自己的配置文件和标签配置表。
			return false;
		strncpy(_cfgfile, scfgfile, sizeof(_cfgfile) - 1);

		//下面安装回调函数
		_onmsg = onmsg;  //消息日志回调函数
		_onmsgparam = onmsgparam;

		_ontagval = ontagval; //值标签数据记录回调函数
		_ontagvalparam = ontagvalparam;

		_ontagobj = ontagobj; //对象标签数据记录回调函数
		_ontagobjparam = ontagobjparam;

		_onsoe = onsoe; //SOE回掉函数
		_onsoeparam = onsoeparam;

		return true;
	}
	int  GetAllTags(bool(*ontag)(const char* srdbtagname, int ntype, int naccess, void *param), void* pontagparam)
	{
		_tags.for_each([ontag, pontagparam](t_tagitem &v) {ontag(v.tagname, v.type, v.access, pontagparam); });
		return DACRET_OK;
	}
	int  GetAllTagsEx(bool(*ontagex)(const char* srdbtagname, int ntype, int naccess, const char* sunit, const char* sdes, void *param), void* pontagparam)
	{
		_tags.for_each([ontagex, pontagparam](t_tagitem &v) {ontagex(v.tagname, v.type, v.access, v.unit, v.des, pontagparam); });
		return DACRET_OK;
	}
	int start()
	{
		if (IsRun())
			return DACRET_OK;
		StartThread(0);
		return DACRET_OK;
	}
	int stop()
	{
		StopThread();
		return DACRET_OK;
	}

	int  WriteVal(rec_tagval* ptagv) //控制输出,返回0表示成功,其他为错误码
	{
		//将ptagv输出到设备，这里直接返回成功
		return DACRET_OK;
	}

	int  WriteObj(rec_tagobj* ptagv) //控制输出,返回0表示成功,其他为错误码
	{
		//将ptagv输出到设备，这里直接返回成功
		return DACRET_OK;
	}
private:

	bool load_cfg(const char* sfile) //读入配置文件
	{
		//从sfile文件中读取配置。本例子驱动没有配置。
		//一般标签表文件名也配置配置文件中，这里没有标签表，直接模拟生成两个标签。
		_tags.clear();

		t_tagitem t;
		memset(&t, 0, sizeof(t));
		strcpy(t.tagname, "simu1.f32r");
		strcpy(t.unit, "u");
		strcpy(t.des, "simu1.f32r_des");
		t.type = DT_FLOAT32;
		t.access = DRVTAG_R;
		_tags.add(t);

		strcpy(t.tagname, "simu1.i32rw");
		strcpy(t.unit, "uw");
		strcpy(t.des, "simu1.i32rw_des");
		t.type = DT_INT32;
		t.access = DRVTAG_RW; //可读写
		_tags.add(t);

		return true;
	}

private:
	char _sdevice[256]; //设备名
	char _cfgfile[1024];//全路径配置文件

	dac_onmsg _onmsg;       //消息日志回调函数
	void *_onmsgparam;

	dac_ontagval _ontagval; //值标签数据记录回调函数
	void *_ontagvalparam;

	dac_ontagobj _ontagobj; //对象标签数据记录回调函数
	void* _ontagobjparam;

	dac_onsoe  _onsoe;      //SOE回掉函数
	void* _onsoeparam;

	Array<t_tagitem, 8> _tags;//这里简单的用一个8个标签容量的固定数组来存储标签定义，实际应用中应该使用map
protected:
	time_t _tlast;//上次模拟数据的时间

	virtual	void dojob() //线程运行主循环
	{ 
		std::this_thread::sleep_for(std::chrono::milliseconds(100)); 
		time_t tcur = ::time(0);
		if (tcur - _tlast <= 0) //1秒模拟一次数据
			return;
		_tlast = tcur;

		rec_tagval v;
		strcpy(v.sname, "simu1.f32r"); //这里模拟一个数据即可。
		v.val.time = tcur * 10;//转换为实时库时间
		v.val.i32 = (int)(tcur % 60);//秒
		v.val.cerr = 0;
		v.val.cqa = 0;
		v.val.cvt = DT_INT32;
		v.val.unres = 0;
		
		if (_ontagval)
			_ontagval(&v, 1, _ontagvalparam);//提交数据给实时库，这里只模拟了一个数据，实际情况接收到数据后放到一个数组里一起提交。
	};
};

tHandle<cSimuSrv> g_cls; //驱动对象句柄管理

//下面就是接口函数的实现了。
extern "C"
{
	int dac_getversion()
	{
		return 500;
	}

	int dac_create(const char* sdevicename, const char* scfgfile,
		dac_onmsg onmsg, void* onmsgparam,
		dac_ontagval ontagval, void* ontagvalparam,
		dac_ontagobj ontagobj, void *ontagobjparam,
		dac_onsoe onsoe, void* onsoeparam
	)
	{
		int h = g_cls.CreateHandle();
		if (h < 0)
			return DACRET_ERRHANDLE;
		cSimuSrv* pcls = g_cls.GetClsByHandle(h);
		if (!pcls->Create(sdevicename, scfgfile, onmsg, onmsgparam, ontagval, ontagvalparam, ontagobj, ontagobjparam, onsoe, onsoeparam))
		{
			g_cls.DelHandle(h);
			return DACRET_ERRHANDLE;
		}
		return h;
	}

	void dac_destroy(int h)
	{
		g_cls.DelHandle(h);
	}

	int dac_getalltags(int h, dac_ontag ontag, void* ontagparam)
	{
		cSimuSrv* pcls = g_cls.GetClsByHandle(h);
		if (!pcls)
			return DACRET_ERRHANDLE;
		return pcls->GetAllTags(ontag, ontagparam);
	}

	int dac_getalltagsex(int h, dac_ontagex ontag, void* ontagparam)
	{
		cSimuSrv* pcls = g_cls.GetClsByHandle(h);
		if (!pcls)
			return DACRET_ERRHANDLE;
		return pcls->GetAllTagsEx(ontag, ontagparam);
	}

	int dac_start(int h)
	{
		cSimuSrv* pcls = g_cls.GetClsByHandle(h);
		if (!pcls)
			return DACRET_ERRHANDLE;
		return pcls->start();
	}

	int dac_stop(int h)
	{
		cSimuSrv* pcls = g_cls.GetClsByHandle(h);
		if (!pcls)
			return DACRET_ERRHANDLE;
		return pcls->stop();
	}

	bool dac_isrun(int h)
	{
		cSimuSrv* pcls = g_cls.GetClsByHandle(h);
		if (!pcls)
			return false;
		return pcls->IsRun();
	}

	int dac_devicewriteval(int h, rec_tagval *pval)
	{
		cSimuSrv* pcls = g_cls.GetClsByHandle(h);
		if (!pcls)
			return DACRET_ERRHANDLE;
		return pcls->WriteVal(pval);
	}

	int dac_devicewriteobj(int h, rec_tagobj *pobj)
	{
		cSimuSrv* pcls = g_cls.GetClsByHandle(h);
		if (!pcls)
			return DACRET_ERRHANDLE;
		return pcls->WriteObj(pobj);
	}
}
