﻿/*!
\file rdbapix.js

dbman专用的新版JS websocekt客户端
对客户端websocket和登录界面做了简单包装，目的是减少html页面的脚本量。

用法:
  需要一个模式对话框，一个工具条上的登录按钮(可选)

var g_wsc = new CRdbWebsocket();
g_wsc.onReadCls = OnMsgReadData; //安装处理数据消息
g_wsc.onLoginOk = QueryTags;//安装登录成功函数

\author tomsoft jiangyong
\update 
    2025-4-18 改为ES6 class 包装
*/

var info_page_footer = "RDB manager 5.0.10 <a href=\"http://www.kipway.com\">重庆唐码软件有限公司</a>  © 2009-2025 ";

class CRdbWebsocket {
	constructor() {
		this._ManualLogin = false; //true为手动登录
		this._loginst = false;  //当前登录状态

		this.idbutton = "idbt_wslogin"; //登录按钮的ID
		this.iddlglogin = "dlglogin"; //登录模态对话框ID

		this.idwsurl = "ws_url"; // 登录对话框中 url input text的ID
		this.idwsuser = "ws_user"; //登录对话框中 user input text的ID
		this.idwspsw = "ws_psw"; //登录对话框中 password input text的ID
		this.idnavurl = null; //nav中显示当前url的P标签ID

		this.id_sswsurl = "_sswsurl"; //url 暂存key
		this.id_sswsusr = "_sswsusr"; //user 暂存key
		this.id_sswspswd = "_sswspswd"; //password 暂存key

		this._wsurl = "";
		this._wsusr = "";
		this._wspsw = "";
		this._wsprotocol = "rdb5"; // Sec-WebSocket-Protocol 值，应用层定义,默认"rdb5"

		this._seqno = 0;
		this._wsobject = null;  // WS连接对象

		this.onLoginOk = () => { };//登录成功
		this.onClose = () => { }; //关闭，应用层可安装
		this.onOrgMessage = (event) => { }; //原始消息，应用层可安装实现原始消息处理
		this.onReadCls = (obj) => { }; //读取到的消息对象，已经解为对象,应用层必须安装才有意义

		this.dbver = 5000;
		this.timefmt = 0; // 0: lcoal; 1: iso; 2: jsnum 登录成功后协商的时标格式
	}

    /**
     * 获取下一个序列号
     * @returns 返回 1-2147483646
     */
    nextseqno() {
        this._seqno++;
        if (this._seqno === 2147483647)
            this._seqno = 1;
        return this._seqno;
    }

    /**
     * 登录状态改变
     * @param {boolean} status
     * @param {string} errmsg
     */
    onLoginStatus(status, errmsg) {
        if (status == false) {
            if (this.idbutton && this.idbutton != "") {
                $('#' + this.idbutton).text("请登录");
            }
            if (this._ManualLogin) {
                this._ManualLogin = false;
                alert("登录失败: " + errmsg);
            }
        }
        else {
            if (this.idbutton && this.idbutton != "") {
                $('#' + this.idbutton).text(this._wsusr);
            }
            this.onLoginOk();
        }
    }

    /**
     * 连接服务器
     * @param {string} wsurl ws://192.168.1.59:921
     * @param {string} usr 登录账号
     * @param {string} psw 登录密码
     * @returns {boolean} true or false
     */
    connect(wsurl, usr, psw) {        
		this._wsurl = wsurl;
		this._wsusr = usr;
		this._wspsw = psw;
		try {
			this._wsobject = new WebSocket(this._wsurl, this._wsprotocol);
		} catch (e) {
			console.log("RdbWebsocket new WebSocket Err:", e);
			return false;
        }

		this._wsobject.onopen = (event) => {
			var oreq = {};
			oreq.request = "rdb_login";
			oreq.seqno = this.nextseqno();
            oreq.name = this._wsusr;
			oreq.timefmt = "iso"; // rdb2023.3开始支持协商时标，默认为local时区字符串格式.
			oreq.workmode = "manage";//rdb2023.4开始支持工作模式，默认为 "work" 模式.
			this.send(JSON.stringify(oreq));
        };

		this._wsobject.onmessage = (event) => {
			var cls = null;
			this.onOrgMessage(event);
			try {
				cls = JSON.parse(event.data);
			}
			catch (e) {
				console.log("RdbWebsocket _onmessage  JSON.parse Err:", e);
				return;
			}
			if (cls.response === "rdb_login") {
				if (cls.status !== 0) {
					console.log("onlogin Err:", cls);
					this.onLoginStatus(false, cls.message);
					this._wsobject.close();
					this._wsobject = null;
					return;
				}
				if (undefined != cls.version)
					this.dbver = cls.version;
				if (undefined != cls.timefmt) { //解析协商的时标格式
					let sl = cls.timefmt.toLowerCase();
					this.timefmt = 0; // local
					switch (sl) {
						case "iso":
							this.timefmt = 1; // iso
							break;
						case "jsnum":
							this.timefmt = 2; // jsnum
					}
				}
				var oreq = {};
				oreq.request = "rdb_auth";
				oreq.seqno = this.nextseqno();
				oreq.vals = hex_md5(cls.vals + hex_md5(this._wspsw).toUpperCase()).toUpperCase();
				this.send(JSON.stringify(oreq));
			} else if (cls.response === "rdb_auth") {
				if (cls.status !== 0) {
					console.log("onauth Err:", cls);
					this.onLoginStatus(false, cls.message);
					this._wsobject.close();
					this._wsobject = null;

				} else {
					console.log("login success!", cls);
					sessionStorage.setItem(this.id_sswsurl, this._wsurl);
					sessionStorage.setItem(this.id_sswsusr, this._wsusr);
					sessionStorage.setItem(this.id_sswspswd, this._wspsw);
					this.onLoginStatus(true, "success");
					this._loginst = true;
				}
			}
			else {
				this.onReadCls(cls);
			}
		};

		this._wsobject.onclose = (event) => {
			console.log("wso_onclose", event);
			this._loginst = false;
            if (this.idbutton && this.idbutton != "") {
                $('#' + this.idbutton).text("请登录");
			}
            this.onClose(event);
		};

		if (this.idnavurl != null)
			$('#' + this.idnavurl).text(this._wsurl);
		return true;	        
    }

    /**
     * 自动登录，从sessionStorage中获取登录参数
     * @returns {boolean}
     */
	autologin() {
        if (!this._wsobject) {
            try {
                let wsurl = sessionStorage.getItem(this.id_sswsurl);
                let usr = sessionStorage.getItem(this.id_sswsusr);
                let psw = sessionStorage.getItem(this.id_sswspswd);
                if (!wsurl || !usr || !psw)
                    return false;
                return this.connect(wsurl, usr, psw);
            } catch (e) {
                console.log("wso_autoLogin Err:", e);
                return false;
            }
        }
        return true;
    }

    /**
     * 主动断开连接
     */
	disconnect() {
        try {
            sessionStorage.removeItem(this.id_sswsurl);
            sessionStorage.removeItem(this.id_sswsusr);
            sessionStorage.removeItem(this.id_sswspswd);
            if (this._wsobject) {
                this._wsobject.close();
                this._wsobject = null;
                if (this.idbutton && this.idbutton != "") {
                    $('#' + this.idbutton).text("请登录");
                }
            }
            this._loginst = false;
        }
        catch (e) {
            console.log("wso_disconnet Err:", e);
        }
    }

    /**
     * 发送JSON字符串
     * @param {string} str
     * @returns {boolean}
     */
    send(str) {
        try {
            if (this._wsobject === null || this._wsobject.readyState !== this._wsobject.OPEN)
                return false;
            this._wsobject.send(str);
        } catch (e) {
            return false;
        }
        return true;
    }

    /**
     * 响应到工具栏登录按钮动作上的函数。
     */
	onbtlogin() {
		if (!this._loginst) {
			let spro = location.protocol;
			if (spro.toLowerCase().includes('file:'))
				document.getElementById(this.idwsurl).value = "wss://kipway.net";
			else if (spro.toLowerCase().includes('https:'))
				document.getElementById(this.idwsurl).value = "wss://" + location.host;
			else
				document.getElementById(this.idwsurl).value = "ws://" + location.host;
			$('#' + this.iddlglogin).modal('show');
		}
		else {
			this._ManualLogin = false;
			this.disconnect(); //断开
			//  $('#' + this.idbutton).text("Login");
		}
	}

	/**
	 * 响应登录对话框中的按钮
	 * @returns 无
	 */
	ondlgloginbtok() {
		let url = document.getElementById(this.idwsurl).value;
		let usr = document.getElementById(this.idwsuser).value;
		let psw = document.getElementById(this.idwspsw).value;
		if (url && usr && psw) {
			if (!this.connect(url, usr, psw)) {
				alert("登录失败!");
				return;
			}
			this._ManualLogin = true;
		}
	}

    /**
     * 登录成功后url显示到工具栏idwsurl指向的static 控件
     */
	login_panel() {
		let spro = location.protocol;
		if (spro.toLowerCase().includes('file:'))
			document.getElementById(this.idwsurl).value = "wss://kipway.net";
		else if (spro.toLowerCase().includes('https:'))
			document.getElementById(this.idwsurl).value = "wss://" + location.host;
		else
			document.getElementById(this.idwsurl).value = "ws://" + location.host;
		$('#' + this.iddlglogin).modal('show');
	}
}

/**
 * 分离子站名，标签名冒号前的字符串
 * @param {string} tagname
 * @returns {string} or null表示没有
*/
function rdb_tagstation(tagname) {
	let i;
	for (i = 0; i < tagname.length; i++) {
		if (tagname.charAt(i) === ':') {
			return tagname.slice(0, i);
		}
		else if (tagname.charAt(i) === '.')
			break;
	}
	return null;
}

/**
 * 标签分类转换为字符串
 * @param {number} nclass 标签分类
 * @return {string} 返回字符串
 */
function rdb_class2str(nclass) {
	let str = "unkown";
	if (!nclass)
		return "DEC";
	switch (nclass) {
		case 0: str = "DEC"; break;
		case 1: str = "DEFINE"; break;
		case 2: str = "PRESET"; break;
		case 3: str = "CURVE"; break;
		case 4: str = "SYSTEM"; break;
	}
	return str;
}

/**
 * 字符串转为标签分类
 * @param {string} s
 * @returns
 */
function rdb_str2class(s) {
	let sv = s.toUpperCase();
	let v = 0;
	switch (sv) {
		case "DEC": v = 0; break;
		case "DEFINE": v = 1; break;
		case "PRESET": v = 2; break;
		case "CURVE": v = 3; break;
		case "SYSTEM": v = 4; break;
	}
	return v;
}

/**
 * 标签类型转换为字符串
 * @param {number} ndt 标签类型
 * @return {string} 返回至字符串
 */
function rdb_dt2str(ndt) {
	let str = "void";
	switch (ndt) {
		case 1: str = "digital"; break;
		case 2: str = "int32"; break;
		case 3: str = "float32"; break;
		case 4: str = "int64"; break;
		case 5: str = "float64"; break;
		case 6: str = "string"; break;
		case 7: str = "object"; break;
	}
	return str;
}

/**
 * 标签类型字符串转换为数字
 * @param {string} sdt 类型字符串
 * @return {number} 返回数字类型
 */
function rdb_str2dt(sdt) {
	let sl = sdt.toLowerCase();
	let v = 0;
	switch (sl) {
		case "digital":
			v = 1; break;
		case "int":
		case "int32":
			v = 2; break;

		case "float":
		case "float32":
			v = 3; break;

		case "int64":
		case "long":
			v = 4; break;

		case "float64":
		case "double":
			v = 5; break;

		case "string":
		case "str":
			v = 6; break;
		case "object":
		case "obj":
		case "blob":
			v = 7; break;
	}
	return v;
}

/**
 * 标签压缩方式转换字符串
 * @param {number} n 压缩方式
 * @return {string} 返回字符串
 */
function rdb_comp2str(n) {
	let str = "no";
	switch (n) {
		case 1: str = "percent"; break;
		case 2: str = "abs"; break;
		case 3: str = "timer"; break;
		case 4: str = "extimer"; break;
	}
	return str;
}

/**
 * 标签压缩方式字符串转换为数字
 * @param {string} s 压缩方式字符串
 * @return {number} 返回数字
 */
function rdb_str2comp(s) {
	let sl = s.toLowerCase();
	let v = 0;
	switch (sl) {
		case "no":
		case "none":
			v = 0; break;

		case "per":
		case "percent":
			v = 1; break;

		case "value":
		case "abs":
			v = 2; break;

		case "timer":
		case "time":
			v = 3; break;

		case "extimer":
		case "extime":
			v = 4; break;
	}
	return v;
}

/**
 * 质量转换为字符串
 * @param {int} v
 * @returns {string}
 */
function rdb_quality2str(v) {

	let vr = "good";
	if (undefined == v)
		return vr;
	switch (v) {
		case 0:
			break;
		case 1:
			vr = "shutdown";
			break;
		case 2:
			vr = "invalid-data"
			break;
		case 3:
			vr = "invalid-tag";
			break;
		case 4:
			vr = "invalid-time";
			break;
		case 5:
			vr = "manual-set";
			break;
	}
	return vr;
}

/**
 * 判断字符串是否是utf8
 * @param {any} u
 * @returns
 */
function jt_isutf8(u) {
	let i = 0, nb = 0, c = 0x00;
	for (i = 0; i < u.length; i++) {
		c = u[i];
		if (!nb) {
			if (!(c & 0x80))
				continue;
			if (0xc0 == c || 0xc1 == c || c > 0xF4) // RFC 3629
				return false;
			if ((c & 0xFC) == 0xFC) // 1111 1100
				nb = 5;
			else if ((c & 0xF8) == 0xF8) // 1111 1000
				nb = 4;
			else if ((c & 0xF0) == 0xF0) // 1111 0000
				nb = 3;
			else if ((c & 0xE0) == 0xE0) // 1110 1000
				nb = 2;
			else if ((c & 0xC0) == 0xC0) // 1100 0000
				nb = 1;
			else
				return false;
			continue;
		}
		if ((c & 0xC0) != 0x80)
			return false;
		nb--;
	}
	return !nb;
}
/**
 * 检测是不是IE浏览器
 * */
function jt_isie() {
    var Sys = {};
    var ua = navigator.userAgent.toLowerCase();
    var s;
    (s = ua.match(/rv:([\d.]+)\) like gecko/)) ? Sys.ie = s[1] :
        (s = ua.match(/msie ([\d.]+)/)) ? Sys.ie = s[1] :
            (s = ua.match(/firefox\/([\d.]+)/)) ? Sys.firefox = s[1] :
                (s = ua.match(/chrome\/([\d.]+)/)) ? Sys.chrome = s[1] :
                    (s = ua.match(/opera.([\d.]+)/)) ? Sys.opera = s[1] :
                        (s = ua.match(/version\/([\d.]+).*safari/)) ? Sys.safari = s[1] : 0;
    if (Sys.ie) alert("此页面不支持IE浏览器,请使用chrome或firefox");
}

