#!/usr/bin/env python3
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#
# Copyright 2019 (c) Kalycito Infotech Private Limited
#
# modfied by jiangyong 2022-9-7 , del netifaces
#import netifaces
import sys
import os
import socket
import argparse

parser = argparse.ArgumentParser()

parser.add_argument('outdir',
                    type=str,
                    nargs='?',
                    default=os.getcwd(),
                    metavar='<OutputDirectory>')

parser.add_argument('-u', '--uri',
                    metavar="<ApplicationUri>",
                    type=str,
                    default="",
                    dest="uri")

parser.add_argument('-k', '--keysize',
                    metavar="<KeySize>",
                    type=int,
                    dest="keysize")

parser.add_argument('-c', '--certificatename',
                     metavar="<CertificateName>",
                     type=str,
                     default="",
                     dest="certificatename")

args = parser.parse_args()

if not os.path.exists(args.outdir):
    sys.exit('ERROR: Directory %s was not found!' % args.outdir)

keysize = 2048

if args.keysize:
    keysize = args.keysize

if args.uri == "":
    args.uri = "urn:kipway.client.application"
    print("No ApplicationUri given for the certificate. Setting to %s" % args.uri)
os.environ['URI1'] = args.uri

if args.certificatename == "":
    certificatename = "server"
    print("No Certificate name provided. Setting to %s" % certificatename)

if args.certificatename:
     certificatename = args.certificatename

certsdir = os.path.dirname(os.path.abspath(__file__))

#set IP address
os.environ['IPADDRESS1'] = "127.0.0.1"
os.environ['IPADDRESS2'] = "192.168.1.125"
os.environ['IPADDRESS3'] = "192.168.1.36"
os.environ['IPADDRESS4'] = "192.168.1.19"
os.environ['IPADDRESS5'] = "192.168.1.59"
os.environ['IPADDRESS6'] = "192.168.1.233"
os.environ['IPADDRESS7'] = "192.168.1.230"

os.environ['HOSTNAME'] = socket.gethostname()

#填写其他的DNS2
os.environ['HOSTNAME2'] = "kipway.net"
openssl_conf = os.path.join(certsdir, "localhost.cnf")

os.chdir(os.path.abspath(args.outdir))

os.system("""openssl req \
     -config {} \
     -new \
     -nodes \
     -x509 -sha256  \
     -newkey rsa:{} \
     -keyout localhost.key -days 3650 \
     -subj "/C=CN/O=kipway/CN=opcua@kipway"\
     -out localhost.crt""".format(openssl_conf, keysize))
os.system("openssl x509 -in localhost.crt -outform der -out %s_cert.der" % (certificatename))
os.system("openssl rsa -inform PEM -in localhost.key -outform DER -out %s_key.der"% (certificatename))

os.remove("localhost.key")
os.remove("localhost.crt")

print("Certificates generated in " + args.outdir)
